
--Rain parameters
kPPS = 10;               -- Number of particles generated per second
kGravity =100;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("balloon");
  SetBlendMode(kBlendNormal);
  SetNumParticles(100);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(5500);
TestDone = NewTimeout(10000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-380, 300, 0), Vec3(380,300,0) );
   InitVelocity( "vRange", Vec3(-10, -240, 10), Vec3(10,-150, 100) );
--   InitScale( "fRange", 1, 1 );
   InitAge("iRange", 0, 0);
   CreateParticles(newParticles);
  end

   Do("move");
   DoAge("iAge");
  InitColor("cSelect",
Color(0,1,1,.8),
 Color(1,.2,.1,.8), 
Color(1,1,0,.8), 
Color(0,1,0,.8) );

   Do("expire", 10000)
end

